// ==UserScript==
// @name         5ch カスタムレイアウト
// @namespace    http://tampermonkey.net/
// @version      0.7
// @description  5chの広告要素を削除し、スレタイを下部に複製表示（マージン付き）
// @author       You + ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    function hideHidemetoo() {
        const elem = document.getElementById('hidemetoo');
        if (elem) {
            try {
                elem.remove();
            } catch (e) {
                elem.style.display = 'none';
            }
        }
    }

    function hideAdstirParent() {
        const scripts = document.querySelectorAll('script[src="https://js.ad-stir.com/js/adstir.js"]');
        scripts.forEach(script => {
            const parent = script.parentElement;
            if (parent && parent.style.display !== 'none' && !parent.hasAttribute('data-hidden-by-script')) {
                parent.style.display = 'none';
                parent.setAttribute('data-hidden-by-script', 'true');
            }
        });
    }

    function hideAdOverlay() {
        const overlay = document.getElementById('adoverlay');
        if (overlay && overlay.style.display !== 'none') {
            overlay.style.display = 'none';
        }
    }

    function cloneThreadTitleBelow() {
        let newposts = document.querySelector('div.newposts');

        if (!newposts) {
            const navmenus = document.querySelectorAll('div.navmenu');
            if (navmenus.length > 1) {
                newposts = navmenus[1]; // 2番目の navmenu を代用
            }
        }

        const originalTitle = document.getElementById('threadtitle');

        if (newposts && originalTitle && !document.getElementById('threadtitle_bottom')) {
            const clone = originalTitle.cloneNode(true);
            clone.id = 'threadtitle_bottom'; // 新しい ID を設定
            clone.style.marginTop = '1.5em';
            clone.style.marginBottom = '1em';
            clone.style.color = '#e0e0e0';
            clone.style.fontSize = '1.0em';
            clone.style.textAlign = 'center';

            newposts.insertAdjacentElement('afterend', clone);
        }
    }

    // 初回実行
    hideHidemetoo();
    hideAdstirParent();
    hideAdOverlay();
    cloneThreadTitleBelow();

    // 定期チェック（広告再出現対策＋スレタイ複製の冗長防止）
    setInterval(() => {
        hideHidemetoo();
        hideAdstirParent();
        hideAdOverlay();
        cloneThreadTitleBelow();
    }, 2000);

    // CSS強制非表示
    const css = document.createElement('style');
    css.textContent = `
        #hidemetoo,
        #adoverlay {
            display: none !important;
            visibility: hidden !important;
        }

        #threadtitle_bottom {
            font-size: 1.2em;
            font-weight: bold;
            margin-top: 2em;
            margin-bottom: 1em;
        }
    `;
    document.head.appendChild(css);
})();
